//
//  GSSelectableElementProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 27.02.20.
//  Copyright © 2020 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSContainerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSSelectableElementProtocol <NSObject>

/// A pointer to the containing GSLayer object
@property (weak, nonatomic, nullable, readonly) GSLayer *layer;

/// A pointer to the containing object. this might be a layer or a group
#ifdef DEBUG_
@property (unsafe_unretained, nonatomic, nullable) GSContainer *parent;
#else
@property (weak, nonatomic, nullable) GSContainer *parent;
#endif

- (NSPoint)position;

@property (nonatomic, getter=isLocked) BOOL locked;

// TODO: add (optional) `bounds`??

@end

typedef NSObject<GSSelectableElementProtocol> GSSelectableElement;

NS_ASSUME_NONNULL_END
